/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999-2019 ohD(Twitter:@xm6_original)
 *	Copyright (C) 2001-2019 Ryu Takegami (Twitter:@RyuTakegami)
 *	Copyright (C) 2021 GIMONS (Twitter:@kugimoto0715)
 *
 *	[ FDC CRCWFl[^ ]
 */

#include <string.h>
#include <stdlib.h>
#include "xm7.h"
#include "fdc.h"
#include "crcgen.h"

/*
 *	X^eBbN [N
 */
static WORD crc_table[256];						/* CRCe[u */

/*
 *	CRCWFl[^
 *	
 */
void FASTCALL crcgen_init(void)
{
	int i, j;
	WORD c;

	for (i = 0; i < 256; i++) {
		c = (WORD)(i << 8);

		for (j = 0; j < 8; j++) {
			c = (WORD)((c << 1) ^ (c >> 15) * 0x1021);
		}
		crc_table[i] = c;
	}
}

/*-[ CRCvZ ]--------------------------------------------------------------*/

/*
 *	16bit CRCvZ(1oCĝ)
 */
WORD FASTCALL calc_crc_one(WORD crc, BYTE data)
{
	/* vZ */
	crc = (WORD)((crc << 8) ^ crc_table[(BYTE)(crc >> 8) ^ data]);

	/* CRCԂ */
	return crc;
}

/*
 *	16bit CRCvZ
 */
WORD FASTCALL calc_crc(BYTE *p, int size)
{
	WORD c;
	int i;

	/*  */
	c = 0xffff;

	/* vZ */
	for (i = 0; i < size; i++) {
		c = (WORD)(crc_table[(BYTE)(c >> 8) ^ p[i]] ^ (c << 8));
	}

	/* CRCԂ */
	return c;
}

/*
 *	16bit CRCvZAZbg
 */
void FASTCALL calc_set_crc(BYTE *p, int size)
{
	WORD c;
	int i;

	/*  */
	c = 0xffff;

	/* vZ */
	for (i = 0; i < size; i++) {
		c = (WORD)(crc_table[(BYTE)(c >> 8) ^ p[i]] ^ (c << 8));
	}

	/* 2oCgCRCZbg(rbOGfBA) */
	p[size + 0] = (BYTE)(c >> 8);
	p[size + 1] = (BYTE)(c & 0xff);
}

/*
 *	vZ
 *	http://ja.wikipedia.org/wiki/Xorshift
 */
DWORD FASTCALL rand_xor(void)
{
	static DWORD y = 2463534242;

	y = y ^ (y << 13);
	y = y ^ (y >> 17);
	y = y ^ (y << 15);

	return y;
}

